<Query Kind="Statements">
  <Namespace>System.IO.Pipes</Namespace>
</Query>

bool messageMode = true; // Upewnij sie, że serwer i klient ustawiają to samo

if (messageMode)
{
	using var s = new NamedPipeClientStream ("pipedream");

	s.Connect();
	s.ReadMode = PipeTransmissionMode.Message;

	Console.WriteLine (Encoding.UTF8.GetString (ReadMessage (s)));

	byte[] msg = Encoding.UTF8.GetBytes ("Witaj z powrotem!");
	s.Write (msg, 0, msg.Length);
}
else
{
	using var s = new NamedPipeClientStream ("pipedream");

	s.Connect();
	Console.WriteLine (s.ReadByte());
	s.WriteByte (200);                 // Odpowiedz wartością 200.
}

static byte[] ReadMessage (PipeStream s)
{
	MemoryStream ms = new MemoryStream();
	byte[] buffer = new byte [0x1000];      // Wczytuje bloki 4 KB

	do { ms.Write (buffer, 0, s.Read (buffer, 0, buffer.Length)); }
	while (!s.IsMessageComplete);

	return ms.ToArray();
}